# -*- coding: utf-8 -*-
"""
Created on Wed Mar 09 15:35:06 2016

@author: gareth
"""

import UnitTest as test
import numpy

from CModel import CModel

print "Testing: CModel"

"""
Peak
Normalised
NormalisedPeak
"""

model = CModel()
concentrations = numpy.zeros((4,1,1), float)
concentrations[:,0,0] = [0.0, 0.0, 2.0, 0.0]
model.Concentrations = concentrations
test.Compare([2.0],model.PeakConcentrationsOverTime(0))


model = CModel()
concentrations = numpy.zeros((4,1,2), float)
concentrations[:,0,0] = [0.0, 0.0, 2.0, 0.0]
concentrations[:,0,1] = [0.0, 0.0, 0.0, 2.0]
model.Concentrations = concentrations
test.Compare([2.0, 2.0],model.PeakConcentrationsOverTime(0))


model = CModel()
concentrations = numpy.zeros((4,1,2), float)
concentrations[:,0,0] = [0.0, 0.0, 2.0, 0.0]
concentrations[:,0,1] = [0.0, 0.0, 0.0, 3.0]
model.Concentrations = concentrations
test.Compare([2.0, 3.0],model.PeakConcentrationsOverTime(0))


model = CModel()
concentrations = numpy.zeros((4,1,1), float)
expected = concentrations
concentrations[:,0,0] = [0.0, 0.0, 2.0, 0.0]
expected[:,0,0] = [0.0, 0.0, 1.0, 0.0]
model.Concentrations = concentrations
test.Compare(expected,model.NormalisedConcentrations(0))


model = CModel()
concentrations = numpy.zeros((4,1,2), float)
expected = concentrations
concentrations[:,0,0] = [0.0, 0.0, 2.0, 0.0]
concentrations[:,0,1] = [0.0, 0.0, 0.0, 2.0]
expected[:,0,0] = [0.0, 0.0, 1.0, 0.0]
expected[:,0,1] = [0.0, 0.0, 0.0, 1.0]
model.Concentrations = concentrations
test.Compare(expected,model.NormalisedConcentrations(0))


model = CModel()
concentrations = numpy.zeros((4,1,2), float)
expected = concentrations
concentrations[:,0,0] = [0.0, 0.0, 2.0, 0.0]
concentrations[:,0,1] = [0.0, 0.0, 0.0, 4.0]
expected[:,0,0] = [0.0, 0.0, 0.5, 0.0]
expected[:,0,1] = [0.0, 0.0, 0.0, 1.0]
model.Concentrations = concentrations
test.Compare(expected,model.NormalisedConcentrations(0))




model = CModel()
concentrations = numpy.zeros((4,1,1), float)
concentrations[:,0,0] = [0.0, 0.0, 2.0, 0.0]
model.Concentrations = concentrations
test.Compare([1.0],model.PeakNormalisedConcentrationsOverTime(0))


model = CModel()
concentrations = numpy.zeros((4,1,2), float)
concentrations[:,0,0] = [0.0, 0.0, 2.0, 0.0]
concentrations[:,0,1] = [0.0, 0.0, 0.0, 2.0]
model.Concentrations = concentrations
test.Compare([1.0, 1.0],model.PeakNormalisedConcentrationsOverTime(0))


model = CModel()
concentrations = numpy.zeros((4,1,2), float)
concentrations[:,0,0] = [0.0, 0.0, 2.0, 0.0]
concentrations[:,0,1] = [0.0, 0.0, 0.0, 4.0]
model.Concentrations = concentrations
test.Compare([0.5, 1.0],model.PeakNormalisedConcentrationsOverTime(0))



